<?php
/**
 * Template part for displaying related post in single page
 *
 * @package Marpha
 */
$related_post = get_query_var( 'marpha_related_post' );
if( $related_post ): ?>
		<div class="single-related-post">
			<div class="outer-container">
				<div class="container-fluid">
					<h2><?php esc_html_e( 'You may also like', 'marpha' );?></h2>
					<div class="related-post-box-wrapper">
						<?php foreach( $related_post as $p ): ?>
							<div class="related-post-box">
								<div class="related-post-box-inner">
									<?php if( has_post_thumbnail( $p->ID ) ): 
										$alt = get_post_meta( get_post_thumbnail_id( $p->ID ) , '_wp_attachment_image_alt', true );?>
										<img src="<?php echo esc_attr( get_the_post_thumbnail_url( $p->ID, 'full' ) ); ?>"
											alt="<?php the_title_attribute( array(
										        'post' => $p->ID
											   ) ); ?>"
										>
									<?php endif; ?>	
									<h3><a href="<?php echo esc_url( get_the_permalink( $p ) ); ?>"><?php echo esc_html( get_the_title( $p->ID ) ); ?></a></h3>
									<p><?php echo esc_html( wp_trim_words( get_the_excerpt( $p->ID ), 20, '...' ) ); ?></p>
								</div>
							</div>
						<?php endforeach; ?>
					</div>
				</div>
			</div>
		</div>
<?php endif; ?>