<?php
/**
 * Template part for displaying featured news on blog page
 *
 * @package Marpha
 */?>
 <?php $featured_news = marpha_get_featured_news_post(
 		get_theme_mod( 'marpha_feature_type', 'latest' ),
 		get_theme_mod( 'marpha_featured_cat', false ),
 		3
 	);
 ?>
<section class="outer-container">
	<div class="container-fluid">
		<div class="marpha-featured-slider-init">
			<?php foreach ( $featured_news as $f ) : ?>
				<article class="featured-news-slider-items">
					<div class="slider-left-image" style="background: url( <?php echo esc_url( get_the_post_thumbnail_url( $f ) ) ?>), url( <?php echo esc_url( get_stylesheet_directory_uri() . '/assets/front-end/images/default-image.jpg' ) ?> );"></div>
					<div class="featured-news-items-inner">
						<div>
							<div class="featured-cat-link"><?php marpha_cat_links( '','', $f ); ?></div>
							<h3><a href="<?php echo esc_url( get_the_permalink( $f ) ); ?>"><?php echo esc_html( get_the_title( $f ) ); ?></a></h3>
							<?php $trimmed_post = wp_trim_words( get_the_excerpt( $f ), 20, '%marpha%' ); ?>
							<p><?php echo esc_html( str_replace( '%marpha%', esc_html__( '...', 'marpha' ), $trimmed_post ) ); ?></p>
							<?php if( '%marpha%' == substr( $trimmed_post, -8 ) ){ ?>
								<a class="featured-read-more" href="<?php echo esc_url( get_the_permalink( $f ) ); ?>"> <?php echo esc_html__('read more', 'marpha' ); ?></a>
							<?php }
							?>
						</div>
					</div>
				</article>
			<?php endforeach; ?>
		</div>
	</div>
</section>