<?php
/**
 * Functions hooked to custom hook
 *
 * @package Marpha
 */

/*----------------------------------------------------------------------
# Header
-------------------------------------------------------------------------*/

if ( ! function_exists( 'marpha_add_header' ) ) :
    /**
     * Header Layout
     *
     * @since 1.0.0
     */
    function marpha_add_header() { ?>

        <div class="nav-bar bg-white nav-bar-setting transition-35s">
            <div class="outer-container overflow-visible">
                <div class="container-fluid">
                    <div class="row align-items-center">
                        <?php get_template_part( 'template-parts/header/header-layout', '1' ); ?>
                    </div><!-- .row -->
                </div><!-- .container-fluid -->
            </div><!-- .outer-container -->
        </div><!-- .nav-bar -->

    <?php }

endif;
add_action( 'marpha_action_header', 'marpha_add_header', 20 );

/*----------------------------------------------------------------------
# Sidebar hook
-------------------------------------------------------------------------*/
if ( ! function_exists( 'marpha_add_sidebar' ) ) :

    /**
     * Add Sidebar
     *
     * @since 1.0.0
     */
    function marpha_add_sidebar() {

        get_sidebar(); // sidebar area

    }

endif;

add_action( 'marpha_action_sidebar', 'marpha_add_sidebar', 10 );


/*----------------------------------------------------------------------
# Footer widget hook / Footer bar hook
-------------------------------------------------------------------------*/
if ( ! function_exists( 'marpha_add_footer_widgets' ) ) :

    /**
     * Add footer widgets
     *
     * @since 1.0.0
     */
    function marpha_add_footer_widgets() {

        get_template_part( 'template-parts/footer/footer', 'widget' ); // Footer Widget Area

    }

endif;

if ( ! function_exists( 'marpha_add_footer_bar' ) ) :

    /**
     * Add footer bar
     *
     * @since 1.0.0
     */
    function marpha_add_footer_bar() {

        get_template_part( 'template-parts/footer/footer', 'bar' ); // Footer Bar

    }

endif;

add_action( 'marpha_action_footer', 'marpha_add_footer_widgets', 10 );
add_action( 'marpha_action_footer', 'marpha_add_footer_bar', 20 );


/*----------------------------------------------------------------------
# Post navigation hook
-------------------------------------------------------------------------*/
if ( ! function_exists( 'marpha_add_posts_pagination' ) ) :

    /**
     * Add custom posts pagination
     *
     * @since 1.0.0
     */
    function marpha_add_posts_pagination() {

        the_posts_pagination();

    }

endif;

add_action( 'marpha_action_posts_pagination', 'marpha_add_posts_pagination', 10 );

/*----------------------------------------------------------------------
# Blog page featured section hook
-------------------------------------------------------------------------*/
if( !function_exists( 'marpha_add_featured_section_home' ) ):
    /**
     * Add featured section on home page
     *
     * @since 1.0.0
     */
    function marpha_add_featured_section_home(){
        if( is_archive() || is_search() ){
            return;
        }
        if( !get_theme_mod( 'marpha_featured_section', true ) ){
            return;
        }
        get_template_part( 'template-parts/blog/featured', 'news' );
    }
endif;

add_action( 'marpha_before_blog_content', 'marpha_add_featured_section_home' );

/*----------------------------------------------------------------------
# Before footer hook
-------------------------------------------------------------------------*/
if( !function_exists( 'marpha_single_related_post' ) ):
    /**
     * Adds related post on single page
     *
     * @since 1.0.0
     */
    function marpha_single_related_post(){
        if( !is_single() ){
            return;
        }
        $related = get_posts( 
            array( 
                'category__in' => wp_get_post_categories( get_the_ID() ), 
                'numberposts'  => 4, 
                'post__not_in' => array( get_the_ID() ) 
            ) 
        );
        if( $related ){
            set_query_var( 'marpha_related_post', $related );
            get_template_part( 'template-parts/post/single-related', 'post' );
            
            wp_reset_postdata();
        }
    }
endif;
add_action( 'marpha_before_footer', 'marpha_single_related_post' );