<?php
/**
 * Envy Blog Customizer General Panel
 *
 * @package Marpha
 */

if ( ! function_exists( 'marpha_customizer_typography_controls_init' ) ) :

    function marpha_customizer_typography_controls_init() {
        /*--------------------------------------------------------------
        # Typography Panel
        --------------------------------------------------------------*/
        Kirki::add_panel( 'marpha_typography_panel', array(
            'priority'      => 101,
            'title'         => esc_html__( 'Typography', 'marpha' ),
        ));

        /*--------------------------------------------------------------
        # Sections
        --------------------------------------------------------------*/
        $sections = array(
            'marpha_typography_body_section'             => array( esc_html__( 'Body', 'marpha' ), '' ),
            'marpha_typography_logo_section'             => array( esc_html__( 'Logo', 'marpha' ), '' ),
            'marpha_typography_main_menu_section'        => array( esc_html__( 'Main Menu', 'marpha' ), '' ),
            'marpha_typography_heading_h1_section'       => array( esc_html__( 'H1', 'marpha' ), '' ),
            'marpha_typography_heading_h2_section'       => array( esc_html__( 'H2', 'marpha' ), '' ),
            'marpha_typography_heading_h3_section'       => array( esc_html__( 'H3', 'marpha' ), '' ),
            'marpha_typography_heading_h4_section'       => array( esc_html__( 'H4', 'marpha' ), '' ),
            'marpha_typography_heading_h5_section'       => array( esc_html__( 'H5', 'marpha' ), '' ),
            'marpha_typography_heading_h6_section'       => array( esc_html__( 'H6', 'marpha' ), '' ),
            'marpha_typography_post_meta_section'        => array( esc_html__( 'Post Meta', 'marpha' ), '' ),
            'marpha_typography_widgets_title_section'    => array( esc_html__( 'Widget Title', 'marpha' ), '' ),
        );
        foreach ( $sections as $section_id => $section ) {
            $section_args = array(
                'title'       => $section[0],
                'description' => $section[1],
                'panel'       => 'marpha_typography_panel',
            );
            if ( isset( $section[2] ) ) {
                $section_args['type'] = $section[2];
            }
            Kirki::add_section( $section_id, $section_args );
        }

        /*--------------------------------------------------------------
        # Body Typography & Control
        --------------------------------------------------------------*/
        marpha_add_field(
            array(
                'type'        => 'typography',
                'settings'    => 'marpha_typography_body',
                'label'       => esc_html__( 'Body', 'marpha' ),
                'section'     => 'marpha_typography_body_section',
                'default'     => array(
                    'font-family'    => 'Roboto',
                    'variant'        => 'regular',
                    'subsets'        => array( 'latin-ext' ),
                ),
                'output'      => array(
                    array(
                        'element' => 'body',
                    ),
                ),
            )
        );

        /*--------------------------------------------------------------
        # Site Title Typography & Control
        --------------------------------------------------------------*/
        marpha_add_field(
            array(
                'type'        => 'typography',
                'settings'    => 'marpha_typography_site_title',
                'label'       => esc_html__( 'Site Title', 'marpha' ),
                'section'     => 'marpha_typography_logo_section',
                'default'     => array(
                    'font-family'    => 'Roboto',
                    'variant'        => 'regular',
                    'subsets'        => array( 'latin-ext' ),
                ),
                'output'      => array(
                    array(
                        'element' => '.site-branding .site-title',
                    ),
                ),
            )
        );

        /*--------------------------------------------------------------
        # Tagline Typography & Control
        --------------------------------------------------------------*/
        marpha_add_field(
            array(
                'type'        => 'typography',
                'settings'    => 'marpha_typography_site_tagline',
                'label'       => esc_html__( 'Site Tagline', 'marpha' ),
                'section'     => 'marpha_typography_logo_section',
                'default'     => array(
                    'font-family'    => 'Roboto',
                    'variant'        => 'regular',
                    'subsets'        => array( 'latin-ext' ),
                ),
                'output'      => array(
                    array(
                        'element' => '.site-branding p',
                    ),
                ),
            )
        );

        /*--------------------------------------------------------------
        # Main Menu Typography & Control
        --------------------------------------------------------------*/
        marpha_add_field(
            array(
                'type'        => 'typography',
                'settings'    => 'marpha_typography_main_menu',
                'label'       => esc_html__( 'Main Menu', 'marpha' ),
                'section'     => 'marpha_typography_main_menu_section',
                'default'     => array(
                    'font-family'    => 'Roboto',
                    'variant'        => 'regular',
                    'subsets'        => array( 'latin-ext' ),
                ),
                'output'      => array(
                    array(
                        'element' => '.main-navigation ul li',
                    ),
                ),
            )
        );


        /*--------------------------------------------------------------
        # H1 Typography & Control
        --------------------------------------------------------------*/
        marpha_add_field(
            array(
                'type'        => 'typography',
                'settings'    => 'marpha_typography_heading_h1',
                'label'       => esc_html__( 'H1', 'marpha' ),
                'section'     => 'marpha_typography_heading_h1_section',
                'default'     => array(
                    'font-family'    => 'Roboto',
                    'variant'        => 'regular',
                    'subsets'        => array( 'latin-ext' ),
                ),
                'output'      => array(
                    array(
                        'element' => 'h1',
                    ),
                ),
            )
        );

        /*--------------------------------------------------------------
        # H2 Typography & Control
        --------------------------------------------------------------*/
        marpha_add_field(
            array(
                'type'        => 'typography',
                'settings'    => 'marpha_typography_heading_h2',
                'label'       => esc_html__( 'H2', 'marpha' ),
                'section'     => 'marpha_typography_heading_h2_section',
                'default'     => array(
                    'font-family'    => 'Roboto',
                    'variant'        => '500',
                    'subsets'        => array( 'latin-ext' ),
                ),
                'output'      => array(
                    array(
                        'element' => 'h2',
                    ),
                ),
            )
        );

        /*--------------------------------------------------------------
        # H3 Typography & Control
        --------------------------------------------------------------*/
        marpha_add_field(
            array(
                'type'        => 'typography',
                'settings'    => 'marpha_typography_heading_h3',
                'label'       => esc_html__( 'H3', 'marpha' ),
                'section'     => 'marpha_typography_heading_h3_section',
                'default'     => array(
                    'font-family'    => 'Roboto',
                    'variant'        => 'regular',
                    'subsets'        => array( 'latin-ext' ),
                ),
                'output'      => array(
                    array(
                        'element' => 'h3',
                    ),
                ),
            )
        );

        /*--------------------------------------------------------------
        # H4 Typography & Control
        --------------------------------------------------------------*/
        marpha_add_field(
            array(
                'type'        => 'typography',
                'settings'    => 'marpha_typography_heading_h4',
                'label'       => esc_html__( 'H4', 'marpha' ),
                'section'     => 'marpha_typography_heading_h4_section',
                'default'     => array(
                    'font-family'    => 'Roboto',
                    'variant'        => 'regular',
                    'subsets'        => array( 'latin-ext' ),
                ),
                'output'      => array(
                    array(
                        'element' => 'h4',
                    ),
                ),
            )
        );

        /*--------------------------------------------------------------
        # H5 Typography & Control
        --------------------------------------------------------------*/
        marpha_add_field(
            array(
                'type'        => 'typography',
                'settings'    => 'marpha_typography_heading_h5',
                'label'       => esc_html__( 'H5', 'marpha' ),
                'section'     => 'marpha_typography_heading_h5_section',
                'default'     => array(
                    'font-family'    => 'Roboto',
                    'variant'        => 'regular',
                    'subsets'        => array( 'latin-ext' ),
                ),
                'output'      => array(
                    array(
                        'element' => 'h5',
                    ),
                ),
            )
        );

        /*--------------------------------------------------------------
        # H6 Typography & Control
        --------------------------------------------------------------*/
        marpha_add_field(
            array(
                'type'        => 'typography',
                'settings'    => 'marpha_typography_heading_h6',
                'label'       => esc_html__( 'H6', 'marpha' ),
                'section'     => 'marpha_typography_heading_h6_section',
                'default'     => array(
                    'font-family'    => 'Roboto',
                    'variant'        => 'regular',
                    'subsets'        => array( 'latin-ext' ),
                ),
                'output'      => array(
                    array(
                        'element' => 'h6',
                    ),
                ),
            )
        );

        /*--------------------------------------------------------------
        # Post Meta Typography & Control
        --------------------------------------------------------------*/
        marpha_add_field(
            array(
                'type'        => 'typography',
                'settings'    => 'marpha_typography_post_meta',
                'label'       => esc_html__( 'Post Meta', 'marpha' ),
                'section'     => 'marpha_typography_post_meta_section',
                'default'     => array(
                    'font-family'    => 'Roboto',
                    'variant'        => 'regular',
                    'subsets'        => array( 'latin-ext' ),
                ),
                'output'      => array(
                    array(
                        'element' => '.entry-meta label',
                    ),
                ),
            )
        );

        /*--------------------------------------------------------------
        # Widget Title Typography & Control
        --------------------------------------------------------------*/
        marpha_add_field(
            array(
                'type'        => 'typography',
                'settings'    => 'marpha_typography_widgets_title',
                'label'       => esc_html__( 'Widget Title', 'marpha' ),
                'section'     => 'marpha_typography_widgets_title_section',
                'default'     => array(
                    'font-family'    => 'Roboto',
                    'variant'        => 'regular',
                    'subsets'        => array( 'latin-ext' ),
                ),
                'output'      => array(
                    array(
                        'element' => '.widget-title',
                    ),
                ),
            )
        );
    }
endif;
add_action( 'init', 'marpha_customizer_typography_controls_init', 999 );
