<?php
/**
 * Theme Customizer Social Panel
 *
 * @package Marpha
 */

if ( ! function_exists( 'marpha_customizer_social_controls_init' ) ) :

    function marpha_customizer_social_controls_init() {
        /*--------------------------------------------------------------
        # Social Panel
        --------------------------------------------------------------*/
        Kirki::add_panel( 'marpha_social_panel', array(
            'priority'      => 102,
            'title'         => esc_html__( 'Social', 'marpha' ),
        ));

        /*--------------------------------------------------------------
        # Sections
        --------------------------------------------------------------*/
        $sections = array(
            'marpha_social_profile_section'      => array( esc_html__( 'Social Profiles', 'marpha' ), '' ),
        );
        foreach ( $sections as $section_id => $section ) {
            $section_args = array(
                'title'       => $section[0],
                'description' => $section[1],
                'panel'       => 'marpha_social_panel',
            );
            if ( isset( $section[2] ) ) {
                $section_args['type'] = $section[2];
            }
            Kirki::add_section( $section_id, $section_args );
        }

        /*--------------------------------------------------------------
        # Repeatable Social Profile Setting & Control
        --------------------------------------------------------------*/
        marpha_add_field(
            array(
                'type'                  => 'repeater',
                'label'                 => esc_html__( 'Add Social Profile', 'marpha' ),
                'description'           => esc_html__( 'Drag & Drop items to re-arrange order of appearance.', 'marpha' ),
                'section'               => 'marpha_social_profile_section',
                'row_label'             => array(
                    'type'              => 'field',
                    'value'             => esc_html__('Social', 'marpha' ),
                    'field'             => 'social_name',
                ),
                'settings'              => 'marpha_social_repeatable_social_profiles',
                'default'               => array(
                    array(
                        'social_name'   => esc_html__( 'Facebook', 'marpha' ),
                        'social_url'    => '',
                        'social_icon'   => 'fa-facebook',
                        'social_image'  => '',

                    ),
                ),
                'fields'                => array(
                    'social_name'       => array(
                        'type'          => 'text',
                        'label'         => esc_html__( 'Profile Name', 'marpha' ),
                        'default'       => '',
                    ),
                    'social_url'        => array(
                        'type'          => 'text',
                        'label'         => esc_html__( 'URL', 'marpha' ),
                        'default'       => '',
                    ),
                    'social_icon'       => array(
                        'label'         => esc_html__( 'Icon', 'marpha' ),
                        'type'          => 'select',
                        'default'       => 'fa-facebook',
                        'choices'       => marpha_social_profiles()
                    ),
                    'social_image'      => array(
                        'type'          => 'image',
                        'label'         => esc_html__( 'Custom Icon', 'marpha' ),
                        'default'       => '',
                    ),
                ),
            )
        );

    }
endif;
add_action( 'init', 'marpha_customizer_social_controls_init', 999 );
