<?php
/**
 * Theme Customizer Global Panel
 *
 * @package Marpha
 */

if ( ! function_exists( 'marpha_customizer_sidebar_controls_init' ) ) :

    function marpha_customizer_sidebar_controls_init()
    {
        /*--------------------------------------------------------------
        # Panel
        --------------------------------------------------------------*/
        Kirki::add_panel('marpha_sidebar_settings_panel', array(
            'priority' => 122,
            'title' => esc_html__('Sidebar Settings', 'marpha'),
        ));

        /*--------------------------------------------------------------
        # Sections
        --------------------------------------------------------------*/
        $sections['marpha_sidebar_section'] = array(esc_html__('Sidebar', 'marpha'), '');
        $sections['marpha_sidebar_spacing_section'] = array(esc_html__('Spacing', 'marpha'), '');
        $sections['marpha_sidebar_typography_section'] = array(esc_html__('Typography', 'marpha'), '');

        foreach ($sections as $section_id => $section) {
            $section_args = array(
                'title' => $section[0],
                'description' => $section[1],
                'panel' => 'marpha_sidebar_settings_panel',
            );
            if (isset($section[2])) {
                $section_args['type'] = $section[2];
            }
            Kirki::add_section($section_id, $section_args);
        }

        /*--------------------------------------------------------------
        # Sidebar Layout
        --------------------------------------------------------------*/
        marpha_add_field(
            array(
                'type' => 'radio-image',
                'settings' => 'marpha_sidebar_layout',
                'label' => esc_html__('Layout', 'marpha'),
                'description' => esc_html__('This sidebar will be reflected in whole site blog, archives, categories, tags, authors and search result page.', 'marpha'),
                'section' => 'marpha_sidebar_section',
                'default' => 'right-sidebar',
                'choices' => array(
                    'full-width' => MARPHA_THEME_URI . '/assets/back-end/images/sidebar/no-sidebar.svg',
                    'left-sidebar' => MARPHA_THEME_URI . '/assets/back-end/images/sidebar/left-sidebar.svg',
                    'right-sidebar' => MARPHA_THEME_URI . '/assets/back-end/images/sidebar/right-sidebar.svg',
                ),
            )
        );
    }

endif;
add_action( 'init', 'marpha_customizer_sidebar_controls_init', 999 );
