<?php
/**
 * Theme Customizer sticky sidebar options
 *
 * @package Marpha
 */
if ( ! function_exists( 'marpha_customizer_sticky_sidebar_options_control_init' ) ) :

    function marpha_customizer_sticky_sidebar_options_control_init() {

    	/*--------------------------------------------------------------
    	# Sections
    	--------------------------------------------------------------*/

	    $section_args = array(
	        'title'       => esc_attr__( 'Sticky Sidebar Options', 'marpha' ),
	        'panel'       => 'marpha_options_panel',
	    );

	    Kirki::add_section( 'marpha_sticky_sidebar_options_section', $section_args );

        /*--------------------------------------------------------------
        # Breadcrumb Enable/disable
        --------------------------------------------------------------*/
        marpha_add_field(
            array(
                'type'        => 'toggle',
                'settings'    => 'marpha_breadcrumb_sticky_sidebar',
                'label'       => esc_attr__( 'Enable Sticky Sidebar', 'marpha' ),
                'description' => esc_html__( 'Enable or disable sticky sidebar from this section.', 'marpha' ),
                'section'     => 'marpha_sticky_sidebar_options_section',
                'default'     => false,
            )
        );

    }

endif;
add_action( 'init', 'marpha_customizer_sticky_sidebar_options_control_init', 999 );