<?php
/**
 * Theme Customizer color options
 *
 * @package Marpha
 */
if ( ! function_exists( 'marpha_customizer_footer_copyright_options_control_init' ) ) :

    function marpha_customizer_footer_copyright_options_control_init() {

    	/*--------------------------------------------------------------
    	# Sections
    	--------------------------------------------------------------*/

	    $section_args = array(
	        'title'       => esc_attr__( 'Footer Options', 'marpha' ),
	        'panel'       => 'marpha_options_panel',
	    );

	    Kirki::add_section( 'marpha_footer_options_section', $section_args );

    	/*--------------------------------------------------------------
    	# Color options > header text color
    	--------------------------------------------------------------*/
    	marpha_add_field(
    	    array(
    	    	'type'        => 'textarea',
    	    	'settings'    => 'marpha_copyright_text',
                'label'       => esc_html__( 'Copyright Text', 'marpha' ),
    	    	'description'       => esc_html__( 'Edit your own copyright text.', 'marpha' ),
    	    	'section'     => 'marpha_footer_options_section',
    	    	'default'     => esc_html__( 'Copyright All Right Reserved 2020', 'marpha' ),
    	    )
    	);
    }

endif;
add_action( 'init', 'marpha_customizer_footer_copyright_options_control_init', 999 );