<?php
/**
 * Theme Customizer Featured Options
 *
 * @package Marpha
 */
if ( ! function_exists( 'marpha_customizer_theme_options_control_init' ) ) :

    function marpha_customizer_theme_options_control_init() {
    	/*--------------------------------------------------------------
    	# Marpha Options panel
    	--------------------------------------------------------------*/
    	Kirki::add_panel( 'marpha_options_panel', array(
    	    'priority'      => 2,
    	    'title'         => esc_html__( 'Marpha Options', 'marpha' ),
    	));

    	/*--------------------------------------------------------------
    	# Sections
    	--------------------------------------------------------------*/
    	$sections = array(
    	    'marpha_home_feature_section'      => array(
                esc_html__( 'Feature Options', 'marpha' ),
                esc_html__( 'Home page slider section.', 'marpha' )
            ),
    	);
    	foreach ( $sections as $section_id => $section ) {
    	    $section_args = array(
    	        'title'       => $section[0],
    	        'description' => $section[1],
    	        'panel'       => 'marpha_options_panel',
    	    );
    	    if ( isset( $section[2] ) ) {
    	        $section_args['type'] = $section[2];
    	    }
    	    Kirki::add_section( $section_id, $section_args );
    	}

    	/*--------------------------------------------------------------
    	# Home Featured Enable/disable
    	--------------------------------------------------------------*/
    	marpha_add_field(
    	    array(
    	        'type'        => 'toggle',
    	        'settings'    => 'marpha_featured_section',
    	        'label'       => esc_attr__( 'Enable', 'marpha' ),
    	        'section'     => 'marpha_home_feature_section',
    	        'default'     => true,
    	    )
    	);

    	/*--------------------------------------------------------------
    	# Home Featured Radio Button for latest post or category
    	--------------------------------------------------------------*/
    	marpha_add_field(
    		array(
    			'type'        => 'radio-buttonset',
    			'settings'    => 'marpha_feature_type',
    			'label'       => esc_html__( 'Featured News Type', 'marpha' ),
    			'section'     => 'marpha_home_feature_section',
    			'default'     => 'latest',
    			'priority'    => 20,
    			'choices'     => array(
    				'latest'   => esc_html__( 'Latest Post', 'marpha' ),
    				'category' => esc_html__( 'From Category', 'marpha' ),
    			),
    			'active_callback' => array(
    				array(
    					'setting'  => 'marpha_featured_section',
    					'operator' => '==',
    					'value'    => true,
    				)
    			),
    		)
    	);

    	/*--------------------------------------------------------------
    	# Home Featured Category Dropdown
    	--------------------------------------------------------------*/
    	$marpha_cat = Kirki_Helper::get_terms( 'category' );
    	$marpha_cat[ 0 ] = esc_html__( 'All', 'marpha' );
    	marpha_add_field(
    		array(
    			'type'        => 'select',
    			'settings'    => 'marpha_featured_cat',
    			'label'       => esc_html__( 'Select Category', 'marpha' ),
    			'section'     => 'marpha_home_feature_section',
    			'default'     => 0,
    			'priority'    => 30,
    			'choices'     => $marpha_cat,
    			'active_callback' => array(
    				array(
	    				'setting'  => 'marpha_feature_type',
	    				'operator' => '==',
	    				'value'    => 'category',	
    				),
    				array(
    					'setting'  => 'marpha_featured_section',
    					'operator' => '==',
    					'value'    => true,
    				)
    			),
    		)
    	);
    }

endif;
add_action( 'init', 'marpha_customizer_theme_options_control_init', 999 );