<?php
/**
 * Theme Customizer color options
 *
 * @package Marpha
 */
if ( ! function_exists( 'marpha_customizer_color_options_control_init' ) ) :

    function marpha_customizer_color_options_control_init() {

    	/*--------------------------------------------------------------
    	# Sections
    	--------------------------------------------------------------*/

	    $section_args = array(
	        'title'       => esc_attr__( 'Color Options', 'marpha' ),
	        'panel'       => 'marpha_options_panel',
	    );

	    Kirki::add_section( 'marpha_color_options_section', $section_args );

    	/*--------------------------------------------------------------
    	# Color options > header text color
    	--------------------------------------------------------------*/
    	marpha_add_field(
    	    array(
    	    	'type'        => 'color',
    	    	'settings'    => 'marpha_header_text_color',
    	    	'label'       => esc_html__( 'Header Text Color', 'marpha' ),
    	    	'section'     => 'marpha_color_options_section',
    	    	'default'     => '#000000',
    	    	'choices'   => array(
    	    	    'alpha' => true,
    	    	),
    	    	'transport'     => 'postMessage',
    	    	'js_vars'       => array(
    	    	    array(
    	    	        'element'   => array(
    	    	        	'.site-branding .site-title a',
    	    	        	'.site-branding .site-description'
    	    	        ),
    	    	        'function'  => 'css',
    	    	        'property'  => 'color'
    	    	    )
    	    	),
    	    	'output' => array(
    	    	    array(
    	    	        'element'   => array(
    	    	        	'.site-branding .site-title a',
    	    	        	'.site-branding .site-description'    	    	        	
    	    	        ),
    	    	        'function'  => 'css',
    	    	        'property'  => 'color'
    	    	    )
    	    	)
    	    )
    	);

    	/*--------------------------------------------------------------
    	# Color options > header text color
    	--------------------------------------------------------------*/
    	marpha_add_field(
    	    array(
    	    	'type'        => 'color',
    	    	'settings'    => 'marpha_primary_color',
    	    	'label'       => esc_html__( 'Primary Color', 'marpha' ),
    	    	'description' => esc_html__( 'Change your whole website color from here. More are available on premium version', 'marpha' ),
    	    	'section'     => 'marpha_color_options_section',
    	    	'default'     => '#dd3333',
    	    	'choices'   => array(
    	    	    'alpha' => true,
    	    	),
    	    	'transport'     => 'postMessage',
    	    	'js_vars'       => array(
    	    	    array(
    	    	        'element'   => array(
    	    	        	'.featured-news-items-inner h3 a:hover, .post-meta-item a:hover, a.featured-read-more:hover, .archived-posts article.post-col .entry-title a:hover, .back-to-top .bt-text:hover, .primary-menu li a:hover,.header-search .icon-search, .header-social .social-profiles-widget ul li a, .featured-cat-link a, .archived-posts article.post-col .post-meta-item, .archived-posts article.post-col .post-meta-item a, .page-header .page-title label, .widget ul li a:hover',
    	    	        ),
    	    	        'function'  => 'css',
    	    	        'property'  => 'color'
    	    	    )
    	    	),
    	    	'output' => array(
    	    	    array(
    	    	        'element'   => array(
    	    	        	'.featured-news-items-inner h3 a:hover, .post-meta-item a:hover, a.featured-read-more:hover, .archived-posts article.post-col .entry-title a:hover, .back-to-top .bt-text:hover, .primary-menu li a:hover, .header-search .icon-search, .header-social .social-profiles-widget ul li a, .featured-cat-link a, .archived-posts article.post-col .post-meta-item, .archived-posts article.post-col .post-meta-item a, .page-header .page-title label, .widget ul li a:hover',
    	    	        ),
    	    	        'function'  => 'css',
    	    	        'property'  => 'color'
    	    	    )
    	    	)
    	    )
    	);
    }

endif;
add_action( 'init', 'marpha_customizer_color_options_control_init', 999 );