<?php
/**
 * Theme Customizer breadcrumb options
 *
 * @package Marpha
 */
if ( ! function_exists( 'marpha_customizer_breadcrumb_options_control_init' ) ) :

    function marpha_customizer_breadcrumb_options_control_init() {

    	/*--------------------------------------------------------------
    	# Sections
    	--------------------------------------------------------------*/

	    $section_args = array(
	        'title'       => esc_attr__( 'Breadcrumb Options', 'marpha' ),
	        'panel'       => 'marpha_options_panel',
	    );

	    Kirki::add_section( 'marpha_breadcrumb_options_section', $section_args );

        /*--------------------------------------------------------------
        # Breadcrumb Enable/disable
        --------------------------------------------------------------*/
        marpha_add_field(
            array(
                'type'        => 'toggle',
                'settings'    => 'marpha_breadcrumb_on_off',
                'label'       => esc_attr__( 'Enable Breadcrumb', 'marpha' ),
                'description' => esc_html__( 'Breadcrumb will appear on all pages except home page. More settings will be on the premium version.', 'marpha' ),
                'section'     => 'marpha_breadcrumb_options_section',
                'default'     => true,
            )
        );

    }

endif;
add_action( 'init', 'marpha_customizer_breadcrumb_options_control_init', 999 );