<?php
/**
 * Theme Customizer Header Panel
 *
 * @package Marpha
 */

if ( ! function_exists( 'marpha_customizer_header_controls_init' ) ) :

    function marpha_customizer_header_controls_init() {
        /*--------------------------------------------------------------
        # Panel Header
        --------------------------------------------------------------*/
        Kirki::add_panel( 'marpha_header_panel', array(
            'priority'      => 3,
            'title'         => esc_html__( 'Header', 'marpha' ),
        ));

        /*--------------------------------------------------------------
        # Sections
        --------------------------------------------------------------*/
        $sections = array(
            'marpha_header_social_profile_section'       => array( esc_html__( 'Social Profile', 'marpha' ), '' ),
            'marpha_header_search_section'               => array( esc_html__( 'Header Search', 'marpha' ), '' ),
            'marpha_header_search_section'               => array( esc_html__( 'Header Search', 'marpha' ), '' ),

        );

        foreach ( $sections as $section_id => $section ) {
            $section_args = array(
                'title'       => $section[0],
                'description' => $section[1],
                'panel'       => 'marpha_header_panel',
            );

            if ( isset( $section[2] ) ) {
                $section_args['type'] = $section[2];
            }

            Kirki::add_section( $section_id, $section_args );
        }


        /*--------------------------------------------------------------
        # Site Title Control
        --------------------------------------------------------------*/
        marpha_add_field(
            array(
                'type'          => 'toggle',
                'settings'      => 'marpha_header_site_title_visible',
                'section'       => 'title_tagline',
                'label'         => esc_html__( 'Display Site Title', 'marpha' ),
                'default'       => '1',
            )
        );

        /*--------------------------------------------------------------
        # Tagline Control
        --------------------------------------------------------------*/
        marpha_add_field(
            array(
                'type'              => 'toggle',
                'label'             => esc_html__( 'Display Tagline', 'marpha' ),
                'settings'          => 'marpha_header_site_tagline_visible',
                'section'           => 'title_tagline',
            )
        );

        /*------------------------------------------------------
        # Header Social
        -------------------------------------------------------*/
        marpha_add_field(
            array(
                'type'              => 'toggle',
                'settings'          => 'marpha_header_social_profile_enable',
                'section'           => 'marpha_header_social_profile_section',
                'label'             => esc_html__( 'Enable', 'marpha' ),
                'description'       => esc_html__( 'Enable Social Profiles.', 'marpha' ),
                'default'           => '1',
            )
        );

        /*------------------------------------------------------
       #  Header Social: Note
       -------------------------------------------------------*/
        marpha_add_field(
            array(
                'type'              => 'custom',
                'settings'          => 'marpha_header_social_profile_note',
                'section'           => 'marpha_header_social_profile_section',
                'label'             => esc_html__( 'Social Profiles', 'marpha' ),
                'description'       => esc_html__( 'To set Social Profiles, go to customizer -> Social -> Social Profiles and add your required profiles.', 'marpha' ),
            )
        );

        /*--------------------------------------------------------------
        # Enable Search Control
        --------------------------------------------------------------*/
        marpha_add_field(
            array(
                'type'              => 'toggle',
                'settings'          => 'marpha_header_search_enable',
                'section'           => 'marpha_header_search_section',
                'label'             => esc_html__( 'Enable', 'marpha' ),
                'default'           => '1',
                'partial_refresh'   => array(
                    'marpha_header_search_enable'    => array(
                        'selector'                  => '.header-search',
                        'render_callback'           => '__return_false',

                    ),
                ),
            )
        );

        /*--------------------------------------------------------------
        # Header Search Widgets Column Control
        --------------------------------------------------------------*/
        marpha_add_field(
            array(
                'type'          => 'custom',
                'settings'      => 'marpha_header_search_custom_blank',
                'label'         => esc_html__( 'Search Input', 'marpha' ),
                'description'   => esc_html__( 'To add Search input, go to widgets(http://marpha.local/wp-admin/widgets.php) and add "Search" widget to Search Popup Column 1.', 'marpha' ),
                'section'       => 'marpha_header_search_section',
            )
        );

        /*--------------------------------------------------------------
        # Header Search Background Control
        --------------------------------------------------------------*/
        marpha_add_field(
            array(
                'type'      => 'color',
                'settings'  => 'marpha_header_search_bg_color',
                'section'   => 'marpha_header_search_section',
                'label'     => esc_html__( 'Background', 'marpha' ),
                'default'   => 'rgba(255,255,255,1)',
                'choices'   => array(
                    'alpha' => true,
                ),
                'transport'     => 'postMessage',
                'js_vars'       => array(
                    array(
                        'element'   => array( '.search-popup' ),
                        'function'  => 'css',
                        'property'  => 'background'
                    )
                ),
                'output'        => array(
                    array(
                        'element'   => array( '.search-popup' ),
                        'function'  => 'css',
                        'property'  => 'background'
                    )
                )
            )
        );

    }
endif;
add_action( 'init', 'marpha_customizer_header_controls_init', 999 );
