<?php
/**
 * Theme Customizer General Panel
 *
 * @package Marpha
 */

if ( ! function_exists( 'marpha_customizer_general_controls_init' ) ) :

    function marpha_customizer_general_controls_init() {
        /*--------------------------------------------------------------
        # Panel
        --------------------------------------------------------------*/
        Kirki::add_panel( 'marpha_general_panel', array(
            'priority'  =>  2,
            'title'     =>  esc_html__( 'General Settings', 'marpha' ),
        ));

        /*--------------------------------------------------------------
        # Sections
        --------------------------------------------------------------*/
        $sections = array('marpha_general_colors_section'    => array( esc_html__( 'Colors', 'marpha' ), '' ) );

        foreach ( $sections as $section_id => $section ) {
            $section_args = array(
                'title'       => $section[0],
                'description' => $section[1],
                'panel'       => 'marpha_general_panel',
            );
            if ( isset( $section[2] ) ) {
                $section_args['type'] = $section[2];
            }
            Kirki::add_section( $section_id, $section_args );
        }

        /*--------------------------------------------------------------
        # Background Color
        --------------------------------------------------------------*/
        marpha_add_field(
            array(
                'type'          => 'color',
                'label'         => esc_html__( 'Background Color', 'marpha' ),
                'settings'      => 'marpha_body_background_color',
                'section'       => 'marpha_general_colors_section',
                'default'       => '#fff',
                'transport'     => 'postMessage',
                'js_vars'   => array(
                    array(
                        'element'       => array( 'body', '.archived-posts article.post-col.landscape-img.have-sep::before', '.archived-posts article.post-col.full-width-img.have-sep::before' ),
                        'property'      => 'background-color',
                    ),
                ),
                'output'   =>  array(
                    array(
                        'element'       => array( 'body', '.archived-posts article.post-col.landscape-img.have-sep::before', '.archived-posts article.post-col.full-width-img.have-sep::before' ),
                        'property'      => 'background-color',
                    ),
                ),
            )
        );

    }
endif;
add_action( 'init', 'marpha_customizer_general_controls_init', 999 );
