<?php
/**
 * Theme Customizer Post Panel
 *
 * @package Marpha
 */

if ( ! function_exists( 'marpha_customizer_footer_controls_init' ) ) :

    function marpha_customizer_footer_controls_init() {
        /*--------------------------------------------------------------
        # Panel
        --------------------------------------------------------------*/
        Kirki::add_panel( 'marpha_footer_panel', array(
            'priority'      => 126,
            'title'         => esc_html__( 'Footer', 'marpha' ),
        ));

        /*--------------------------------------------------------------
        # Sections
        --------------------------------------------------------------*/
        $sections = array(
            'marpha_footer_widgets_section'      => array( esc_html__( 'Widgets', 'marpha' ), '' ),
        );
        foreach ( $sections as $section_id => $section ) {
            $section_args = array(
                'title'       => $section[0],
                'description' => $section[1],
                'panel'       => 'marpha_footer_panel',
            );
            if ( isset( $section[2] ) ) {
                $section_args['type'] = $section[2];
            }
            Kirki::add_section( $section_id, $section_args );
        }

        /*--------------------------------------------------------------
        # Footer Widgets: Enable
        --------------------------------------------------------------*/
        marpha_add_field(
            array(
                'type'          => 'toggle',
                'settings'      => 'marpha_footer_widget_area_activate',
                'label'         => esc_html__( 'Enable', 'marpha' ),
                'description'   => esc_html__( 'Enable it to display Footer Widget Area on all Pages.', 'marpha' ),
                'section'       => 'marpha_footer_widgets_section',
                'default'       => 1,
                'partial_refresh'   => array(
                    'marpha_footer_widget_area_activate'   => array(
                        'selector'                          => '.site-footer .footer-widgets',
                        'render_callback'                   => '__return_false',
                    ),
                ),
            )
        );

        /*--------------------------------------------------------------
        # Footer Widgets: Background Overlay Color
        --------------------------------------------------------------*/
        marpha_add_field(
            array(
                'type'        => 'color',
                'label'       => esc_html__( 'Background Overlay', 'marpha' ),
                'settings'    => 'marpha_footer_widget_section_bg_color',
                'section'     => 'marpha_footer_widgets_section',
                'default'     => 'rgba(0,0,0,0.01)',
                'choices'     => array(
                    'alpha' => true,
                ),
                'transport' => 'postMessage',
                'js_vars'   => array(
                    array(
                        'element'  => array( '.footer-widgets::before' ),
                        'property' => 'background-color',
                    )
                ),
                'output'   => array(
                    array(
                        'element'  => array( '.footer-widgets::before' ),
                        'property' => 'background-color',
                    )
                ),
            )
        );
    }

endif;
add_action( 'init', 'marpha_customizer_footer_controls_init', 999 );
