<?php
/**
 * Theme Customizer Blog Panel
 *
 * @package Marpha
 */

if ( ! function_exists( 'marpha_customizer_blog_controls_init' ) ) :

    function marpha_customizer_blog_controls_init() {
        /*--------------------------------------------------------------
        # Panel
        --------------------------------------------------------------*/
        Kirki::add_panel( 'marpha_archive_panel', array(
            'priority'      => 122,
            'title'         => esc_html__( 'Archive/Blog Settings', 'marpha' ),
        ));

        /*--------------------------------------------------------------
        # Sections
        --------------------------------------------------------------*/
        $sections = array('marpha_archive_sidebar_section'              => array( esc_html__( 'Sidebar', 'marpha' ), '' ) );

        foreach ( $sections as $section_id => $section ) {
            $section_args = array(
                'title'       => $section[0],
                'description' => $section[1],
                'panel'       => 'marpha_archive_panel',
            );
            if ( isset( $section[2] ) ) {
                $section_args['type'] = $section[2];
            }
            Kirki::add_section( $section_id, $section_args );
        }

        /*--------------------------------------------------------------
        # Archive/Blog Sidebar Layout
        --------------------------------------------------------------*/
        marpha_add_field(
            array(
                'type'        => 'radio-image',
                'settings'    => 'marpha_archive_sidebar_layout',
                'label'       => esc_html__( 'Sidebar Layout', 'marpha' ),
                'description' => esc_html__( 'Default layout is inherit from customizer -> sidebar settings -> sidebar. Assign new default layout for all archive pages.','marpha' ),
                'section'     => 'marpha_archive_sidebar_section',
                'default'     => 'right-sidebar',
                'choices'     => array(
                    'default'           => MARPHA_THEME_URI . '/assets/back-end/images/sidebar/default-sidebar.svg',
                    'left-sidebar'      => MARPHA_THEME_URI . '/assets/back-end/images/sidebar/left-sidebar.svg',
                    'full-width'        => MARPHA_THEME_URI . '/assets/back-end/images/sidebar/no-sidebar.svg',
                    'right-sidebar'     => MARPHA_THEME_URI . '/assets/back-end/images/sidebar/right-sidebar.svg',

                ),
            )
        );


    }

endif;
add_action( 'init', 'marpha_customizer_blog_controls_init', 999 );
