<?php
/**
 * The header for our theme
 *
 * This is the template that displays all of the <head> section and everything up until <div id="content">
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package Marpha
 */

$header_class   = array( 'site-header' );
$header_class[] = 'header-layout-1';
$header_class[] = 'scroll';
$header_class[] = 'transition-5s'; ?>

<!doctype html>
<html <?php language_attributes(); ?>>
<head>
    <meta charset="<?php bloginfo( 'charset' ); ?>" />
    <meta name="viewport" content="width=device-width, initial-scale=1" />
    <link rel="profile" href="https://gmpg.org/xfn/11" />
    <?php wp_head(); ?>
</head>

<body <?php body_class(); ?>>
    <?php 
    //wp_body_open hook from WordPress 5.2
    if ( function_exists( 'wp_body_open' ) ) {
        wp_body_open();
    } ?>
<div id="page" class="site website-container">
    <a class="skip-link screen-reader-text" href="#content"><?php esc_html_e( 'Skip to content', 'marpha' ); ?></a>

    <?php do_action( 'marpha_before_header' ); ?>

    <header id="masthead" class="<?php echo esc_attr( implode( ' ', $header_class ) ); ?>">

        <?php
        /**
         * Hook - marpha_action_header
         *
         * @hooked: marpha_add_header    - 20
         */
        do_action( 'marpha_action_header' ); ?>

    </header><!-- #masthead -->

    <div class="site-header-separator"></div>

    <?php do_action( 'marpha_after_header' ); ?>

<div id="content" class="site-content">
