/* File skip-link-focus-fix */
( function() {
    var isIe = /(trident|msie)/i.test( navigator.userAgent );

    if ( isIe && document.getElementById && window.addEventListener ) {
        window.addEventListener( 'hashchange', function() {
            var id = location.hash.substring( 1 ),
                element;

            if ( ! ( /^[A-z0-9_-]+$/.test( id ) ) ) {
                return;
            }

            element = document.getElementById( id );

            if ( element ) {
                if ( ! ( /^(?:a|select|input|button|textarea)$/i.test( element.tagName ) ) ) {
                    element.tabIndex = -1;
                }

                element.focus();
            }
        }, false );
    }
} )();

(function($) {
   'use strict';

    var slickArrLeft =  `
        <div class="slick-prev marpha-arrow marpha-arrow-prev">
            <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" version="1.1" id="Layer_1" x="0px" y="0px" viewBox="0 0 511.991 511.991" style="enable-background:new 0 0 511.991 511.991;" xml:space="preserve" width="50px" height="50px"><g><g>
            <g>
                <path d="M153.433,255.991L381.037,18.033c4.063-4.26,3.917-11.01-0.333-15.083c-4.229-4.073-10.979-3.896-15.083,0.333    L130.954,248.616c-3.937,4.125-3.937,10.625,0,14.75L365.621,508.7c2.104,2.188,4.896,3.292,7.708,3.292    c2.646,0,5.313-0.979,7.375-2.958c4.25-4.073,4.396-10.823,0.333-15.083L153.433,255.991z" data-original="#000000" class="active-path" data-old_color="#000000" />
            </g>
            </g></g> </svg>
        </div>`;
    var slickArrRight = `
        <div class="slick-prev marpha-arrow marpha-arrow-next">
            <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" version="1.1" id="Layer_1" x="0px" y="0px" viewBox="0 0 511.995 511.995" style="enable-background:new 0 0 511.995 511.995;" xml:space="preserve" width="50px" height="50px"><g><g>
            <g>
                <path d="M381.039,248.62L146.373,3.287c-4.083-4.229-10.833-4.417-15.083-0.333c-4.25,4.073-4.396,10.823-0.333,15.083    L358.56,255.995L130.956,493.954c-4.063,4.26-3.917,11.01,0.333,15.083c2.063,1.979,4.729,2.958,7.375,2.958    c2.813,0,5.604-1.104,7.708-3.292L381.039,263.37C384.977,259.245,384.977,252.745,381.039,248.62z" data-original="#000000" class="active-path" data-old_color="#000000" />
            </g>
            </g></g> </svg>
        </div>`;

    // Stop Scrolling
    $.fn.stopScrolling = function() {
        $('html').on('wheel.modal mousewheel.modal', function () {return false;});
        return this;
    };

    jQuery(document).on( 'focus', '.circular-focus', function(){
        jQuery( jQuery(this).data('goto') ).focus();
    });

    // Restore Scrolling
    $.fn.restoreScrolling = function() {
        $('html').off('wheel.modal mousewheel.modal');
        return this;
    };

    // Toggle Menu
    var bodyOverlay = $('.body-overlay');
    $( '.hamburger-menu' ).on( 'click', function() {
        bodyOverlay.addClass('is-active');
        $('.main-navigation').toggleClass('is-active');
        $(this).toggleClass('cross');
        $.fn.stopScrolling();
    });

    $( '.hamburger-menu.cross, .close-navigation' ).on( 'click', function() {
        $('.hamburger-menu').removeClass('cross');
        bodyOverlay.removeClass('is-active');
        $('.main-navigation').removeClass('is-active');
        $.fn.restoreScrolling();
    });

    


    // Keyboard Esc
    $(document).keyup(function(e) {
        if (e.keyCode === 27) {
            $('.search-popup').removeClass('show');
            $('.hamburger-menu').removeClass('cross');
            bodyOverlay.removeClass('is-active');
            $('.main-navigation').removeClass('is-active');
            $('.header-social .social-profiles-section').removeClass('is-active');
            $.fn.restoreScrolling();
        }
    });

    // Restore onClick closeset
    $(document).on( 'click', function (e) {
        if ( $( e.target).closest( '.hamburger-menu,.main-navigation, .header-search .icon-search' ).length === 0 ) {
            bodyOverlay.removeClass('is-active');
            $('.main-navigation').removeClass('is-active');
            $('.hamburger-menu').removeClass('cross');
            $.fn.restoreScrolling();
        }
    });

    jQuery(document).ready(function() {
        jQuery('.sticky-sidebar #primary, .sticky-sidebar #secondary').theiaStickySidebar({
          additionalMarginTop: 30
        });


        $('.main-navigation').ptMmenu();
            // Header Search
        $('.header-search a').on('click', function() {
            $('.search-popup').addClass('show');
            $('body').addClass('search-open');

            setTimeout(function(){
                $('.search-popup').find('.search-field').focus();
            }, 50);

            $.fn.stopScrolling();
        });

        $('.search-close, .slide-in-box-close').on('click', function() {
            $('.search-popup').removeClass('show');
            $('body').removeClass('search-open');
            bodyOverlay.removeClass('is-active');
        });

        $('.search-close a').on('click', function() {
            $('.header-search a').focus();
        });

        $('.header-search a').on('click', function() {
            $('.popup-search-close').focus();
        });

        //slick slider 
    $('.marpha-featured-slider-init').slick({
          infinite: true,
          slidesToShow: 1,
          slidesToScroll: 1,
          autoplay: true,
          autoplaySpeed: 5000,
          speed: 1000,
          prevArrow: slickArrLeft,
          nextArrow: slickArrRight,
          dots: false,
          arrows: true,
          fade: true,
    });

    });

    // Image Gallery
    $('.wp-block-gallery, .gallery').magnificPopup({
        delegate: 'a',
        type: 'image',
        tLoading: 'Loading image #%curr%...',
        closeOnContentClick: false,
        closeBtnInside: false,
        mainClass: 'mfp-with-zoom mfp-img-mobile',
        image: {
            verticalFit: true,
            tError: 'The image can not be loaded.',
            titleSrc: function(item) {
                return item.el.attr('title');
            }
        },
        gallery: {
            enabled: true
        },
        zoom: {
            enabled: true,
            duration: 300, // don't forget to change the duration also in CSS
            opener: function(element) {
                return element.find('img');
            }
        }
    });

    // Back to Top
    if ($('.back-to-top').length) {
        var scrollTrigger = 500, // px
            backToTop = function () {
                var scrollTop = $( window ).scrollTop();
                if (scrollTop > scrollTrigger) {
                    $('.back-to-top').addClass('show');
                } else {
                    $('.back-to-top').removeClass('show');
                }
            };
        backToTop();

        $(window).on('scroll', function() {
            backToTop();
        });

        $('.back-to-top').on('click', function(e) {
            e.preventDefault();
            $('html,body').animate( {
                scrollTop: 0
            }, 800);
        });
    }

})(jQuery);
